/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.ec;

import de.rub.nds.tlsattacker.core.crypto.ec.FieldElement;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import java.math.BigInteger;

public abstract class EllipticCurve {
    private Point basePoint;
    private BigInteger basePointOrder;
    private final BigInteger modulus;

    protected EllipticCurve(BigInteger modulus) {
        this.modulus = modulus;
    }

    protected EllipticCurve(BigInteger modulus, BigInteger basePointX, BigInteger basePointY, BigInteger basePointOrder) {
        this.modulus = modulus;
        this.basePoint = this.getPoint(basePointX, basePointY);
        this.basePointOrder = basePointOrder;
    }

    public Point add(Point p, Point q) {
        if (p.isAtInfinity()) {
            return q;
        }
        if (q.isAtInfinity()) {
            return p;
        }
        if (this.inverse(p).equals(q)) {
            return new Point();
        }
        return this.additionFormular(p, q);
    }

    public Point mult(BigInteger k, Point p) {
        if (k.compareTo(BigInteger.ZERO) < 0) {
            k = k.negate();
            p = this.inverse(p);
        }
        Point q = this.getPoint(BigInteger.ZERO, BigInteger.ZERO);
        for (int i = k.bitLength(); i > 0; --i) {
            q = this.add(q, q);
            if (!k.testBit(i - 1)) continue;
            q = this.add(q, p);
        }
        return q;
    }

    public Point inverse(Point p) {
        if (p.isAtInfinity()) {
            return p;
        }
        return this.inverseAffine(p);
    }

    public abstract Point getPoint(BigInteger var1, BigInteger var2);

    public abstract boolean isOnCurve(Point var1);

    protected abstract Point inverseAffine(Point var1);

    protected abstract Point additionFormular(Point var1, Point var2);

    public Point getBasePoint() {
        return this.basePoint;
    }

    public BigInteger getBasePointOrder() {
        return this.basePointOrder;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public abstract Point createAPointOnCurve(BigInteger var1);

    public abstract FieldElement createFieldElement(BigInteger var1);
}

