/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.crypto.KeyShareCalculator;
import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.crypto.ec.PointFormatter;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.message.computations.PWDComputations;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.preparator.Preparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyShareEntryPreparator
extends Preparator<KeyShareEntry> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final KeyShareEntry entry;

    public KeyShareEntryPreparator(Chooser chooser, KeyShareEntry entry) {
        super(chooser, entry);
        this.entry = entry;
    }

    @Override
    public void prepare() {
        LOGGER.debug("Preparing KeySharePairExtension");
        if (this.chooser.getSelectedCipherSuite().isPWD()) {
            try {
                this.preparePWDKeyShare();
            }
            catch (CryptoException e) {
                throw new PreparationException("Failed to generate password element", e);
            }
        } else {
            this.prepareKeyShare();
        }
        this.prepareKeyShareType();
        this.prepareKeyShareLength();
    }

    private void preparePWDKeyShare() throws CryptoException {
        EllipticCurve curve = CurveFactory.getCurve(this.entry.getGroupConfig());
        Point passwordElement = PWDComputations.computePasswordElement(this.chooser, curve);
        PWDComputations.PWDKeyMaterial keyMaterial = PWDComputations.generateKeyMaterial(curve, passwordElement, this.chooser);
        int curveSize = curve.getModulus().bitLength() / 8;
        this.entry.setPrivateKey(keyMaterial.privateKeyScalar);
        byte[] serializedScalar = ArrayConverter.bigIntegerToByteArray((BigInteger)keyMaterial.scalar);
        this.entry.setPublicKey(ArrayConverter.concatenate((byte[][])new byte[][]{ArrayConverter.bigIntegerToByteArray((BigInteger)keyMaterial.element.getX().getData(), (int)curveSize, (boolean)true), ArrayConverter.bigIntegerToByteArray((BigInteger)keyMaterial.element.getY().getData(), (int)curveSize, (boolean)true), ArrayConverter.intToBytes((int)serializedScalar.length, (int)1), serializedScalar}));
        LOGGER.debug("KeyShare: " + ArrayConverter.bytesToHexString((byte[])((byte[])this.entry.getPublicKey().getValue())));
        LOGGER.debug("PasswordElement.x: " + ArrayConverter.bytesToHexString((byte[])ArrayConverter.bigIntegerToByteArray((BigInteger)passwordElement.getX().getData())));
    }

    private void prepareKeyShare() {
        if (this.entry.getPrivateKey() == null) {
            if (this.chooser.getConnectionEndType().equals((Object)ConnectionEndType.CLIENT)) {
                this.entry.setPrivateKey(this.chooser.getClientEcPrivateKey());
            }
            if (this.chooser.getConnectionEndType().equals((Object)ConnectionEndType.SERVER)) {
                this.entry.setPrivateKey(this.chooser.getServerEcPrivateKey());
            }
        }
        if (this.entry.getGroupConfig().isStandardCurve()) {
            Point ecPublicKey = KeyShareCalculator.createPublicKey(this.entry.getGroupConfig(), this.entry.getPrivateKey());
            byte[] serializedPoint = PointFormatter.formatToByteArray(this.entry.getGroupConfig(), ecPublicKey, this.chooser.getConfig().getDefaultSelectedPointFormat());
            this.entry.setPublicKey(serializedPoint);
        } else if (this.entry.getGroupConfig().isCurve() && !this.entry.getGroupConfig().isStandardCurve()) {
            byte[] publicKey = KeyShareCalculator.createMontgomeryKeyShare(this.entry.getGroupConfig(), this.entry.getPrivateKey());
            this.entry.setPublicKey(publicKey);
        } else {
            throw new UnsupportedOperationException("The group \"" + this.entry.getGroupConfig().name() + "\" is not supported yet");
        }
        LOGGER.debug("KeyShare: " + ArrayConverter.bytesToHexString((byte[])((byte[])this.entry.getPublicKey().getValue())));
    }

    private void prepareKeyShareType() {
        this.entry.setGroup(this.entry.getGroupConfig().getValue());
        LOGGER.debug("KeyShareType: " + ArrayConverter.bytesToHexString((byte[])((byte[])this.entry.getGroup().getValue())));
    }

    private void prepareKeyShareLength() {
        this.entry.setPublicKeyLength(((byte[])this.entry.getPublicKey().getValue()).length);
        LOGGER.debug("KeyShareLength: " + this.entry.getPublicKeyLength().getValue());
    }
}

