/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.ContextAction;
import org.openide.awt.GeneralAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

class PropertyMonitor<T>
implements ContextAction.StatefulMonitor<T>,
PropertyChangeListener,
ChangeListener {
    private static final Logger LOG = Logger.getLogger(PropertyMonitor.class.getName());
    static final String KEY_CHECKED_VALUE = "Value";
    static final String KEY_LISTEN_INTERFACE = "ChangeListener";
    static final String KEY_INTERFACE_METHOD = "Method";
    static final String KEY_CUSTOM_CHECK = "ActionProperty";
    static final String KEY_NULL = "Null";
    private static final int UNINITIALIZED = -1;
    private static final int NONE = 0;
    private static final int PROPERTY_NAME = 1;
    private static final int PROPERTY_ALL = 2;
    private static final int CHANGE = 3;
    private static final int CUSTOM = 4;
    private final Class<T> type;
    private final String property;
    private final Object checkedValue;
    private Class valType;
    private Method refGetter;
    private Method refAddListener;
    private Method refRemoveListener;
    private int listenerType = -1;
    private EventListener weakListener;
    private Reference<T> attachedTo;
    private List<ChangeListener> listeners = null;
    private Class listenerInterface;
    private final String methodName;
    private final ContextAction.StatefulMonitor actionMonitor;
    private final Function<Object, Object> valueFactory;
    private static final Method OBJECT_EQUALS = PropertyMonitor.getObjectMethod("equals", Object.class);
    private static final Method OBJECT_HASHCODE = PropertyMonitor.getObjectMethod("hashCode", new Class[0]);

    public PropertyMonitor(Class<T> clazz, String string) {
        this(clazz, string, "", Collections.emptyMap());
    }

    public PropertyMonitor(Class<T> clazz, String string, String string2, Map map) {
        Object v;
        Object v2;
        this.type = clazz;
        this.property = string;
        Object object = map.get(string2 + KEY_CHECKED_VALUE);
        if (object == null && (v2 = map.get(string2 + KEY_NULL)) instanceof Boolean) {
            object = (Boolean)v2 != false ? "#null" : "#non-null";
        }
        this.checkedValue = object;
        this.valueFactory = this.initValueAccess();
        v2 = map.get(string2 + KEY_LISTEN_INTERFACE);
        String string3 = null;
        if (v2 instanceof String) {
            this.listenerInterface = GeneralAction.readClass(v2);
            v2 = map.get(string2 + KEY_INTERFACE_METHOD);
            if (v2 instanceof String) {
                string3 = (String)v2;
            }
        }
        if ((v = map.get(string2 + KEY_CUSTOM_CHECK)) != null) {
            this.actionMonitor = new PropertyMonitor<Action>(Action.class, v.toString());
        } else {
            if (string == null) {
                throw new IllegalArgumentException("Delegate or guard property must be specified");
            }
            this.actionMonitor = null;
        }
        this.methodName = string3;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T data() {
        PropertyMonitor propertyMonitor = this;
        synchronized (propertyMonitor) {
            return this.attachedTo != null ? (T)this.attachedTo.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        T t = this.data();
        if (t != null) {
            this.clearListeners(t);
        }
        if (this.actionMonitor != null) {
            this.actionMonitor.clear();
        }
        PropertyMonitor propertyMonitor = this;
        synchronized (propertyMonitor) {
            this.attachedTo = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangeListener(ChangeListener changeListener) {
        boolean bl = false;
        PropertyMonitor<T> propertyMonitor = this;
        synchronized (propertyMonitor) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<ChangeListener>();
                bl = true;
            }
            this.listeners.add(changeListener);
        }
        if (bl) {
            propertyMonitor = this.data();
            LOG.log(Level.FINER, "{0}: attaching listener to {1}", new Object[]{this, propertyMonitor});
            if (propertyMonitor != null) {
                this.addListeners(propertyMonitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        boolean bl = false;
        PropertyMonitor<T> propertyMonitor = this;
        synchronized (propertyMonitor) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(changeListener);
            bl = this.listeners.isEmpty();
            if (bl) {
                this.listeners = null;
            }
        }
        if (bl && (propertyMonitor = this.data()) != null) {
            this.clearListeners(propertyMonitor);
        }
    }

    private void clearListeners(Object object) {
        if (this.weakListener == null || this.refRemoveListener == null) {
            return;
        }
        LOG.log(Level.FINER, "{0}: adding listener to {1}", new Object[]{this, object});
        try {
            switch (this.listenerType) {
                case 1: {
                    this.refRemoveListener.invoke(object, this.property, this.weakListener);
                    break;
                }
                case 4: {
                    ((ProxyListener)Proxy.getInvocationHandler(this.weakListener)).unregister(object);
                    break;
                }
                case 2: 
                case 3: {
                    this.refRemoveListener.invoke(object, this.weakListener);
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            exception.printStackTrace();
        }
        this.weakListener = null;
        if (this.actionMonitor != null) {
            this.actionMonitor.removeChangeListener(this);
        }
    }

    private void initListenerReflection() {
        Method method;
        block18: {
            if (this.listenerType != -1) {
                return;
            }
            method = null;
            try {
                if (this.listenerInterface != null) {
                    method = this.type.getMethod("add" + this.listenerInterface.getSimpleName(), this.listenerInterface);
                    this.listenerType = 4;
                    break block18;
                }
                try {
                    if (this.property != null) {
                        method = this.type.getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
                        this.listenerType = 1;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (method == null) {
                    try {
                        method = this.type.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                        this.listenerType = 2;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        method = this.type.getMethod("addChangeListener", ChangeListener.class);
                        this.listenerType = 3;
                    }
                }
            }
            catch (NoSuchMethodException | SecurityException exception) {
                this.listenerType = 0;
                return;
            }
        }
        Method method2 = null;
        try {
            switch (this.listenerType) {
                case 1: {
                    method2 = this.type.getMethod("removePropertyChangeListener", String.class, PropertyChangeListener.class);
                    break;
                }
                case 2: {
                    method2 = this.type.getMethod("removePropertyChangeListener", PropertyChangeListener.class);
                    break;
                }
                case 3: {
                    method2 = this.type.getMethod("removeChangeListener", ChangeListener.class);
                    break;
                }
                case 4: {
                    method2 = this.type.getMethod("remove" + this.listenerInterface.getSimpleName(), this.listenerInterface);
                }
            }
        }
        catch (NoSuchMethodException | SecurityException exception) {
            this.listenerType = -1;
            return;
        }
        this.refAddListener = method;
        this.refRemoveListener = method2;
    }

    public boolean falseGetter(Object object) {
        return false;
    }

    public boolean trueGetter(Object object) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListeners(Object object) {
        if (this.weakListener != null || this.listenerType == 0) {
            return;
        }
        this.initListenerReflection();
        PropertyChangeListener propertyChangeListener = this;
        synchronized (propertyChangeListener) {
            if (this.listeners == null) {
                return;
            }
        }
        LOG.log(Level.FINER, "{0}: adding listener to {1}", new Object[]{this, object});
        try {
            switch (this.listenerType) {
                case 1: {
                    propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this, (String)this.property, (Object)object);
                    this.weakListener = propertyChangeListener;
                    this.refAddListener.invoke(object, this.property, propertyChangeListener);
                    break;
                }
                case 2: {
                    propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)object);
                    this.weakListener = propertyChangeListener;
                    this.refAddListener.invoke(object, propertyChangeListener);
                    break;
                }
                case 3: {
                    ChangeListener changeListener = WeakListeners.change((ChangeListener)this, (Object)object);
                    this.weakListener = changeListener;
                    this.refAddListener.invoke(object, changeListener);
                    break;
                }
                case 0: {
                    return;
                }
                case 4: {
                    ProxyListener proxyListener = new ProxyListener(object, this.methodName, this.refRemoveListener, this);
                    Object object2 = Proxy.newProxyInstance(this.listenerInterface.getClassLoader(), new Class[]{this.listenerInterface, EventListener.class}, (InvocationHandler)proxyListener);
                    proxyListener.proxy = this.weakListener = (EventListener)object2;
                    this.refAddListener.invoke(object, this.weakListener);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            this.listenerType = 0;
        }
        if (this.actionMonitor != null) {
            this.actionMonitor.addChangeListener(this);
        }
    }

    private Function<Object, Object> initValueAccess() {
        Method method = null;
        if (this.property != null) {
            String string = Character.toUpperCase(this.property.charAt(0)) + this.property.substring(1);
            String string2 = "is" + string;
            String string3 = "get" + string;
            try {
                try {
                    method = this.type.getMethod(string2, new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    method = this.type.getMethod(string3, new Class[0]);
                }
                Class<?> clazz = method.getReturnType();
                if (clazz == Boolean.TYPE && clazz == Boolean.class && clazz == String.class && clazz.isEnum() && this.checkedValue != "#null" && this.checkedValue != "#non-null") {
                    method = null;
                }
                this.valType = clazz;
                this.refGetter = method;
                return object -> this.reflectiveGet(object);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        if (this.type == Action.class) {
            return object -> this.inspectAction((Action)object);
        }
        return object -> this.property == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        ChangeListener[] changeListenerArray;
        Object object = this;
        synchronized (object) {
            if (this.listeners == null) {
                return;
            }
            changeListenerArray = this.listeners.toArray(new ChangeListener[0]);
        }
        object = new ChangeEvent(this);
        for (ChangeListener changeListener : changeListenerArray) {
            changeListener.stateChanged((ChangeEvent)object);
        }
    }

    private void refreshListeners(T t) {
        T t2 = this.data();
        if (t2 == t) {
            return;
        }
        if (this.actionMonitor != null) {
            this.actionMonitor.clear();
        }
        if (t2 != null) {
            this.clearListeners(t2);
        }
        if (t != null) {
            this.addListeners(t);
        }
        this.attachedTo = new WeakReference<T>(t);
    }

    private Object reflectiveGet(Object object) {
        try {
            return this.refGetter.invoke(object, new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            return false;
        }
    }

    @Override
    public boolean enabled(List<? extends T> list, Supplier<Action> supplier) {
        Object t;
        Object t2 = t = list.isEmpty() ? null : (Object)list.get(0);
        if (list.isEmpty()) {
            return false;
        }
        this.refreshListeners(t);
        if (t == null) {
            return false;
        }
        if (this.type == Action.class) {
            return this.inspectAction((Action)t);
        }
        Object object = this.valueFactory.apply(t);
        if (!this.interpretAsBoolean(object)) {
            return false;
        }
        if (supplier != null && this.actionMonitor != null) {
            return this.actionMonitor.enabled(Collections.singletonList(supplier.get()), null);
        }
        return true;
    }

    public boolean inspectAction(Action action) {
        if (action == null) {
            return false;
        }
        if ("enabled".equals(this.property)) {
            return action.isEnabled();
        }
        return action.getValue(this.property) == Boolean.TRUE;
    }

    private boolean interpretAsBoolean(Object object) {
        if (object == null) {
            return this.checkedValue == "#null";
        }
        if (this.valType == null || this.valType == Boolean.TYPE || this.valType == Boolean.class) {
            if (this.checkedValue == null) {
                return Boolean.TRUE.equals(object);
            }
            return this.checkedValue.equals(object.toString());
        }
        if (this.checkedValue == null) {
            if (object instanceof Collection) {
                return !((Collection)object).isEmpty();
            }
            if (object instanceof Map) {
                return !((Map)object).isEmpty();
            }
            if (Number.class.isInstance(object)) {
                return ((Number)object).intValue() > 0;
            }
            return false;
        }
        if (this.checkedValue == "#non-null") {
            return true;
        }
        if (!(this.checkedValue instanceof String)) {
            return this.checkedValue.equals(object);
        }
        return this.checkedValue.equals(object.toString());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() != null && this.property != null && !this.property.equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        this.update();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.update();
    }

    public PropertyMonitor(PropertyMonitor propertyMonitor) {
        this.type = propertyMonitor.type;
        this.property = propertyMonitor.property;
        this.checkedValue = propertyMonitor.checkedValue;
        this.listenerType = propertyMonitor.listenerType;
        this.refGetter = propertyMonitor.refGetter;
        this.valueFactory = propertyMonitor.valueFactory;
        this.valType = propertyMonitor.valType;
        this.refAddListener = propertyMonitor.refAddListener;
        this.refRemoveListener = propertyMonitor.refRemoveListener;
        this.listenerInterface = propertyMonitor.listenerInterface;
        this.methodName = propertyMonitor.methodName;
        this.actionMonitor = propertyMonitor.actionMonitor == null ? null : propertyMonitor.actionMonitor.createContextMonitor(Lookup.EMPTY);
    }

    @Override
    public ContextAction.StatefulMonitor<T> createContextMonitor(Lookup lookup) {
        return new PropertyMonitor<T>(this);
    }

    private static Method getObjectMethod(String string, Class ... classArray) {
        try {
            return Object.class.getMethod(string, classArray);
        }
        catch (ReflectiveOperationException | SecurityException exception) {
            throw new IllegalStateException(exception);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PropertyMonitor@").append(System.identityHashCode(this)).append("{").append("class = ").append(this.type.getName()).append(", property = ").append(this.property).append(", valtype = ").append(this.valType == null ? "null" : this.valType.getName()).append(", checkval = ").append(this.checkedValue).append("}");
        return stringBuilder.toString();
    }

    private static class ProxyListener
    extends WeakReference<ChangeListener>
    implements EventListener,
    InvocationHandler,
    Runnable {
        private final Reference theData;
        private final String methodName;
        private final Method removeMethod;
        volatile EventListener proxy;

        public ProxyListener(Object object, String string, Method method, ChangeListener changeListener) {
            super(changeListener, Utilities.activeReferenceQueue());
            this.theData = new WeakReference<Object>(object);
            this.methodName = string;
            this.removeMethod = method;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                if (method == OBJECT_EQUALS) {
                    return this.equals(objectArray[0]);
                }
                if (method == OBJECT_HASHCODE) {
                    return object.hashCode();
                }
                return method.invoke((Object)this, objectArray);
            }
            ChangeListener changeListener = (ChangeListener)this.get();
            Object t = this.theData.get();
            if (t == null) {
                return null;
            }
            if (changeListener == null) {
                return null;
            }
            if (this.methodName == null || method.getName().equals(this.methodName)) {
                ChangeEvent changeEvent = new ChangeEvent(t);
                changeListener.stateChanged(changeEvent);
            }
            return null;
        }

        private void unregister(Object object) {
            if (object == null) {
                return;
            }
            if (this.removeMethod != null) {
                try {
                    this.removeMethod.invoke(object, this.proxy);
                }
                catch (ReflectiveOperationException | SecurityException exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
            this.theData.clear();
        }

        @Override
        public void run() {
            this.unregister(this.theData.get());
        }
    }
}

