untrusted comment: verify with openbsd-73-base.pub
RWQS90bYzZ4XFqRS7ZmbHbOOewbjLO6Q9zv7izN7RsdOMkWL7etY7Q6aIBF0InbMluKvTTHXnq76N1mleN5tm/9w10JiXlh/7ww=

OpenBSD 7.3 errata 019, October 25, 2023:

A network buffer that had to be split at certain length could crash
the kernel.

Apply by doing:
    signify -Vep /etc/signify/openbsd-73-base.pub -x 019_msplit.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/uipc_mbuf.c
===================================================================
RCS file: /cvs/src/sys/kern/uipc_mbuf.c,v
diff -u -p -r1.284 uipc_mbuf.c
--- sys/kern/uipc_mbuf.c	14 Aug 2022 01:58:28 -0000	1.284
+++ sys/kern/uipc_mbuf.c	20 Oct 2023 16:36:14 -0000
@@ -1080,9 +1080,7 @@ m_split(struct mbuf *m0, int len0, int w
 			n->m_len = 0;
 			return (n);
 		}
-		if (m->m_flags & M_EXT)
-			goto extpacket;
-		if (remain > MHLEN) {
+		if ((m->m_flags & M_EXT) == 0 && remain > MHLEN) {
 			/* m can't be the lead packet */
 			m_align(n, 0);
 			n->m_next = m_split(m, len, wait);
@@ -1094,8 +1092,7 @@ m_split(struct mbuf *m0, int len0, int w
 				n->m_len = 0;
 				return (n);
 			}
-		} else
-			m_align(n, remain);
+		}
 	} else if (remain == 0) {
 		n = m->m_next;
 		m->m_next = NULL;
@@ -1104,14 +1101,13 @@ m_split(struct mbuf *m0, int len0, int w
 		MGET(n, wait, m->m_type);
 		if (n == NULL)
 			return (NULL);
-		m_align(n, remain);
 	}
-extpacket:
 	if (m->m_flags & M_EXT) {
 		n->m_ext = m->m_ext;
 		MCLADDREFERENCE(m, n);
 		n->m_data = m->m_data + len;
 	} else {
+		m_align(n, remain);
 		memcpy(mtod(n, caddr_t), mtod(m, caddr_t) + len, remain);
 	}
 	n->m_len = remain;
