untrusted comment: verify with openbsd-75-base.pub
RWRGj1pRpprAfhXtxWkPg5QGkFKLuuHUoYgjG+1iMb1Jnbm3/ZNDxlGNnvyI47Ox/CLkrkMBaX4ZjHsR3L1J9WuPHGqhqWDciwk=

OpenBSD 7.5 errata 023, April 9, 2025:

sshd(8) fix the DisableForwarding directive, which was failing to
disable X11 forwarding and agent forwarding as documented.

Apply by doing:
    signify -Vep /etc/signify/openbsd-75-base.pub -x 023_ssh.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install OpenSSH:
    cd /usr/src/usr.bin/ssh
    make obj
    make
    make install

Index: usr.bin/ssh/session.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/session.c,v
diff -u -p -r1.337 session.c
--- usr.bin/ssh/session.c	1 Feb 2024 02:37:33 -0000	1.337
+++ usr.bin/ssh/session.c	3 Apr 2025 09:52:17 -0000
@@ -1871,7 +1871,8 @@ session_auth_agent_req(struct ssh *ssh, 
 	if ((r = sshpkt_get_end(ssh)) != 0)
 		sshpkt_fatal(ssh, r, "%s: parse packet", __func__);
 	if (!auth_opts->permit_agent_forwarding_flag ||
-	    !options.allow_agent_forwarding) {
+	    !options.allow_agent_forwarding ||
+	    options.disable_forwarding) {
 		debug_f("agent forwarding disabled");
 		return 0;
 	}
@@ -2254,7 +2255,7 @@ session_setup_x11fwd(struct ssh *ssh, Se
 		ssh_packet_send_debug(ssh, "X11 forwarding disabled by key options.");
 		return 0;
 	}
-	if (!options.x11_forwarding) {
+	if (!options.x11_forwarding || options.disable_forwarding) {
 		debug("X11 forwarding disabled in server configuration file.");
 		return 0;
 	}
